unit CustomHttpModule;

interface
    uses
        System.Web, System.ComponentModel;

type
  TCustomHttpModule = class(system.&Object, IHttpModule)
  private
    procedure BeginRequest(Sender: TObject; e: EventArgs);
    procedure EndRequest(Sender: TObject; e: EventArgs);
  public
    procedure Init(context: HttpApplication);
    procedure Dispose;
  end;

implementation

{ TCustomHttpModule }

procedure TCustomHttpModule.Init(context: HttpApplication);
begin
  Include(context.BeginRequest, BeginRequest);
  Include(context.EndRequest, EndRequest)
end;

procedure TCustomHttpModule.Dispose;
begin

end;

procedure TCustomHttpModule.BeginRequest(Sender: TObject; e: EventArgs);
begin
  HttpApplication(Sender).Context.Response.Write('Cabealho');
end;

procedure TCustomHttpModule.EndRequest(Sender: TObject; e: EventArgs);
begin
  HttpApplication(Sender).Context.Response.Write('Rodap');
end;

end.
